<?php

namespace VM\ApiBundle\Controller;

use Doctrine\DBAL\LockMode;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use VM\ApiBundle\Entity\BankService;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;
use VM\ApiBundle\Entity\CompanyBankServiceOption;
use VM\ApiBundle\Exceptions\ApiException;

class BankController extends AbstractController
{
    private $randomEmployeesCount = 100;

    /**
     * @View(serializerGroups={"companyBankServiceDetails"})
     */
    public function loadAction()
    {
        /** @var BankService $BankService */
        try
        {
            $User = $this->getUser();
            $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);

            $response = array();
            $bankServices = $this->getDoctrine()->getRepository('VMApiBundle:BankService')->findAll();
            foreach($bankServices as $BankService)
            {
                $response[$BankService->getId()] = array(
                    'bs' => $BankService,
                    'items' => array()
                );
            }

            foreach($Company->getBankServiceOptions() as $CompanyBankServiceOption)
            {
                $response[$CompanyBankServiceOption->getOption()->getBankServiceId()]['items'][] = $CompanyBankServiceOption;
            }

            return array_values($response);
        }
        catch(\Exception $Exception)
        {
            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }
    }



    /**
     * @View(serializerGroups={"list"})
     */
    public function accountChangesAction($accountId)
    {
        try
        {
            $User = $this->getUser();
            $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
            $CompanyBankServiceOption = $this->getApiGetter()->getCompanyBankServiceOption($accountId);

            if($CompanyBankServiceOption->getCompany() != $Company)
            {
                throw new \Exception('Wrong account');
            }

            return $CompanyBankServiceOption->getAccountChanges();
        }
        catch(\Exception $Exception)
        {
            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }
    }

    /**
     * @View(serializerGroups={"companyBankServiceDetails"})
     */
    public function saveOptionAction()
    {
        $this->getDoctrine()->getConnection()->beginTransaction();
        try
        {
            $User = $this->getUser();
            $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
            $data = $this->getRequest()->request->getIterator()->getArrayCopy();

            $BankServiceOption = $this->getApiGetter()->getBankServiceOption($data['option_id']);
            $Round = $this->getApiGetter()->getRound($data['round_id']);
            $CurrentAccount = $this->getApiGetter()->getCompanyCurrentAccount($Company->getId());

            $this->getDoctrine()->getManager()->lock($CurrentAccount, LockMode::OPTIMISTIC, $CurrentAccount->getVersion());

            if($BankServiceOption->getBankService()->getSymbol() == 'CREDIT')
            {
                $CompanyBankServiceOption = $this->getApiGetter()->getCompanyBankServiceOption($data['id']);
                $currentLoanValue = $CompanyBankServiceOption->getValue();
                $repayLoan = $currentLoanValue - $data['value'];


                if($CurrentAccount->getValue() < $repayLoan)
                {
                    throw new \Exception('Current Account have not enough value.');
                }

                $this->getApiCreator()->changeAccountValue($CompanyBankServiceOption, $Round, -1 * $repayLoan, 'Niewymagalna spłata kredytu');
                $this->getApiCreator()->changeAccountValue($CurrentAccount, $Round, -1 * $repayLoan, 'Spłata kredytu: ' . $CompanyBankServiceOption->getDescription());

            }
            elseif($BankServiceOption->getBankService()->getSymbol() == 'REVOLVING_LOAN' and $data['_operation']=='MODIFY_LOAN'){
                $CompanyBankServiceOption = $this->getApiGetter()->getCompanyBankServiceOption($data['id']);
                $currentLoanValue = $CompanyBankServiceOption->getValue();
                $newLoanValue = $data['value'];

                $loanDifference = $newLoanValue - $currentLoanValue;
                if($loanDifference > 0){
                    // zwiększenie kredytu obrotowego...
                    $this->getApiCreator()->changeAccountValue($CompanyBankServiceOption, $Round, $loanDifference, 'Powiększenie kwoty kredytu obrotowego.');
                    $this->getApiCreator()->changeAccountValue($CurrentAccount, $Round, $loanDifference, 'Powiększenie kwoty kredytu obrotowego.');

                }elseif($loanDifference < 0){
                    // zmniejszenie kredytu obrotowego...
                    if($CurrentAccount->getValue() < ( -1 * $loanDifference) ){
                        throw new \Exception('Current Account have not enough value.');
                    }
                    if($newLoanValue < 1){
                        throw new \Exception('User can not close revolving loan.');
                    }
                    $this->getApiCreator()->changeAccountValue($CompanyBankServiceOption, $Round, $loanDifference, 'Pomniejszenie kwoty kredytu obrotowego.');
                    $this->getApiCreator()->changeAccountValue($CurrentAccount, $Round, $loanDifference, 'Pomniejszenie kwoty kredytu obrotowego.');
                }

            }
            else
            {
                if(empty($data['id']))
                {
                    if($BankServiceOption->getBankService()->getSymbol() != 'REVOLVING_LOAN' && $CurrentAccount->getValue() < $data['value'])
                    {
                        throw new \Exception('Current Account have not enough value.');
                    }

                    $CompanyBankServiceOption = new CompanyBankServiceOption();
                    $CompanyBankServiceOption->setOption($BankServiceOption);
                    $CompanyBankServiceOption->setCompany($Company);
                    $CompanyBankServiceOption->setRound($Round);
                    $CompanyBankServiceOption->setValue($data['value']);

                    $this->getDoctrine()->getManager()->persist($CompanyBankServiceOption);
                    $AccountChange = $this->getApiCreator()->createAccountChange($Round, $Company, -1 * $data['value'], 'Otwarcie lokaty');
                    $this->getDoctrine()->getManager()->persist($AccountChange);

                    if($BankServiceOption->getBankService()->getSymbol() == 'INVESTMENT')
                    {
                        $CurrentAccount->setValue($CurrentAccount->getValue() - $data['value']);
                    }
                    else if($BankServiceOption->getBankService()->getSymbol() == 'REVOLVING_LOAN')
                    {
                        $AccountChange->setDescription('Otwarcie kredytu obrotowego');
                        $AccountChange->setValue($data['value']);
                        $cost = $BankServiceOption->getCost();
                        $CurrentAccount->setValue($CurrentAccount->getValue() + $data['value'] - $cost);
                        $CostAccountChange = $this->getApiCreator()->createAccountChange($Round, $Company, $cost, 'Prowizja za otwarcie kredytu obrotowego');
                        $this->getDoctrine()->getManager()->persist($CostAccountChange);
                    }
                }
                else
                {
                    $CompanyBankServiceOption = $this->getApiGetter()->getCompanyBankServiceOption($data['id']);
                    if($data['value'] == 0 && $CompanyBankServiceOption->getOption()->getFlags() != 'RB')
                    {
                        $AccountChange = $this->getApiCreator()->createAccountChange($Round, $Company, $CompanyBankServiceOption->getValue(), 'Zerwanie lokaty');
                        $this->getDoctrine()->getManager()->persist($AccountChange);

                        if($BankServiceOption->getBankService()->getSymbol() == 'INVESTMENT')
                        {
                            $CurrentAccount->setValue($CurrentAccount->getValue() + $CompanyBankServiceOption->getValue());
                        }
                        else if($BankServiceOption->getBankService()->getSymbol() == 'REVOLVING_LOAN')
                        {
                            $CurrentAccount->setValue($CurrentAccount->getValue() - $CompanyBankServiceOption->getValue());
                            $AccountChange->setDescription('Zamknięcie kredytu obrotowego');
                            $AccountChange->setValue(-1 * $CompanyBankServiceOption->getValue());
                        }

                        $this->getDoctrine()->getManager()->remove($CompanyBankServiceOption);
                    }
                }
            }

            $this->getDoctrine()->getManager()->flush();
            $this->getDoctrine()->getConnection()->commit();
            return $CompanyBankServiceOption;
        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }
    }

}
